<?php
include 'auth.php';
checkRole(['admin', 'tech']); 

try {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['action'], $_POST['NumeroStand']) && is_numeric($_POST['NumeroStand'])) {
            $numeroStand = (int) $_POST['NumeroStand'];
            $action = $_POST['action'];

            if ($action === 'affecter' && isset($_POST['NumeroExp']) && is_numeric($_POST['NumeroExp'])) {
                $numeroExp = (int) $_POST['NumeroExp'];
                if (in_array($_SESSION['role'], ['admin', 'tech'])) {
                    $stmt = $pdo->prepare("UPDATE stand SET NumeroExp = :NumeroExp WHERE NumeroStand = :NumeroStand");
                    $stmt->execute([':NumeroExp' => $numeroExp, ':NumeroStand' => $numeroStand]);
                    echo "<p class='success'>Exposant affecté avec succès.</p>";
                } else {
                    echo "<p class='error'>Vous n'avez pas les droits nécessaires pour effectuer cette action.</p>";
                }
            } elseif ($action === 'deaffecter') {
                if ($_SESSION['role'] === 'admin') {
                    $stmt = $pdo->prepare("UPDATE stand SET NumeroExp = NULL WHERE NumeroStand = :NumeroStand");
                    $stmt->execute([':NumeroStand' => $numeroStand]);
                    echo "<p class='success'>Exposant désaffecté avec succès.</p>";
                } else {
                    echo "<p class='error'>Seuls les administrateurs peuvent désaffecter un exposant.</p>";
                }
            } else {
                echo "<p class='error'>Données non valides.</p>";
            }
        }
    }
} catch (PDOException $e) {
    error_log("Erreur PDO : " . $e->getMessage());
    echo "<p class='error'>Une erreur est survenue. Veuillez réessayer plus tard.</p>";
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Exposants</title>
    <link rel="stylesheet" href="style/styleafexp.css">
</head>
<body>

    <h1>Gestion des Exposants</h1>
    
    <h2>Affecter un exposant</h2>
    <form method="post" action="">
        <label>Numéro de stand :</label>
        <select name="NumeroStand" required>
            <?php
            $stmt = $pdo->query("SELECT NumeroStand FROM stand");
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<option value='{$row['NumeroStand']}'>Stand {$row['NumeroStand']}</option>";
            }
            ?>
        </select>

        <label>Numéro de l'exposant :</label>
        <select name="NumeroExp" required>
            <?php
            $stmt = $pdo->query("SELECT NumeroExp, NomExp FROM exposant");
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<option value='{$row['NumeroExp']}'>" . htmlspecialchars($row['NomExp']) . "</option>";
            }
            ?>
        </select>
        <button type="submit" name="action" value="affecter">Affecter</button>
    </form>

    <h2>Déaffecter un exposant</h2>
    <form method="post" action="">
        <label>Numéro de stand :</label>
        <select name="NumeroStand" required>
            <?php
            $stmt = $pdo->query("SELECT NumeroStand FROM stand");
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<option value='{$row['NumeroStand']}'>Stand {$row['NumeroStand']}</option>";
            }
            ?>
        </select>
        <button type="submit" name="action" value="deaffecter">Déaffecter</button>
    </form>

    <h2>Schéma des stands</h2>
    <div class="stand-grid">
        <?php
        $stmt = $pdo->query("SELECT NumeroStand, NumeroExp FROM stand");
        while ($stand = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $class = ($stand['NumeroExp'] !== null) ? 'selected' : '';
            echo "<div class='stand $class' data-stand='{$stand['NumeroStand']}'>Stand {$stand['NumeroStand']}</div>";
        }
        ?>
    </div>

    <a href="sommaire.php">Retour au sommaire</a>

</body>
</html>
