<?php
include 'auth.php';
checkRole(['admin', 'tech']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add'])) {
        // Validation des champs
        $nom = trim($_POST['NomExp']);
        $rue = trim($_POST['AdrRueExp']) ?: null;
        $cp = trim($_POST['AdrCPExp']) ?: null;
        $ville = trim($_POST['AdrVilleExp']) ?: null;
        $type = $_POST['CodeTypeExp'];

        if (empty($nom) || empty($type)) {
            $message = "Le nom et le type d'exposant sont obligatoires.";
            $messageType = "error";
        } else {
            // Insertion de l'exposant
            $stmt = $pdo->prepare("INSERT INTO exposant (NomExp, AdrRueExp, AdrCPExp, AdrVilleExp, CodeTypeExp) VALUES (:nom, :rue, :cp, :ville, :type)");
            $stmt->execute([':nom' => $nom, ':rue' => $rue, ':cp' => $cp, ':ville' => $ville, ':type' => $type]);
            $message = "Exposant ajouté avec succès.";
            $messageType = "success";
        }
    } elseif (isset($_POST['delete'])) {
        $id = $_POST['id'];
        // Suppression de l'exposant
        $stmt = $pdo->prepare("DELETE FROM exposant WHERE NumeroExp = :id");
        $stmt->execute([':id' => $id]);
        $message = "Exposant supprimé avec succès.";
        $messageType = "success";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Exposants</title>
    <link rel="stylesheet" href="style/styleaexp.css">
</head>
<body>

    <h1>Gestion des Exposants</h1>

    <?php if (!empty($message)): ?>
        <p class="message <?= htmlspecialchars($messageType) ?>">
            <?= htmlspecialchars($message) ?>
        </p>
    <?php endif; ?>

    <h2>Ajouter un nouvel exposant</h2>
    <form method="post" action="">
        <label for="NomExp">Nom Exposant :</label>
        <input type="text" name="NomExp" required>
        
        <label for="AdrRueExp">Rue :</label>
        <input type="text" name="AdrRueExp">
        
        <label for="AdrCPExp">Code Postal :</label>
        <input type="text" name="AdrCPExp">
        
        <label for="AdrVilleExp">Ville :</label>
        <input type="text" name="AdrVilleExp">
        
        <label for="CodeTypeExp">Type Exposant :</label>
        <select name="CodeTypeExp" required>
            <option value="">-- Sélectionner un type --</option>
            <option value="ASS">Association sans but lucratif</option>
            <option value="ENT">Entreprise</option>
            <option value="COM">Commerçant</option>
        </select>

        <button type="submit" name="add">Ajouter</button>
    </form>

    <h2>Supprimer un exposant</h2>
    <form method="post" action="">
        <label for="id">Sélectionner un Exposant :</label>
        <select name="id" required>
            <option value="">-- Sélectionner un exposant --</option>
            <?php
            $stmt = $pdo->query("SELECT NumeroExp, NomExp FROM exposant");
            while ($exposant = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<option value='{$exposant['NumeroExp']}'>" . htmlspecialchars($exposant['NomExp']) . "</option>";
            }
            ?>
        </select>
        
        <button type="submit" name="delete">Supprimer</button>
    </form>

    <a href="sommaire.php">Retour au sommaire</a>

</body>
</html>