<?php
include 'auth.php';
checkRole(['admin', 'tech', 'gp']); 
$whereClauses = [];
$params = [];

if (!empty($_GET['NomExp'])) {
    $whereClauses[] = "NomExp LIKE :NomExp";
    $params[':NomExp'] = '%' . $_GET['NomExp'] . '%';
}
if (!empty($_GET['AdrVilleExp'])) {
    $whereClauses[] = "AdrVilleExp LIKE :AdrVilleExp";
    $params[':AdrVilleExp'] = '%' . $_GET['AdrVilleExp'] . '%';
}
if (!empty($_GET['AdrCPExp'])) {
    $whereClauses[] = "AdrCPExp LIKE :AdrCPExp";
    $params[':AdrCPExp'] = '%' . $_GET['AdrCPExp'] . '%';
}

$whereSQL = count($whereClauses) > 0 ? 'WHERE ' . implode(' AND ', $whereClauses) : '';
$query = "
    SELECT NumeroExp, NomExp, AdrRueExp, AdrCPExp, AdrVilleExp, CodeTypeExp
    FROM exposant
    $whereSQL
";
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$exposants = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Liste des Exposants</title>
    <link rel="stylesheet" href="style/liste_exposant.css">
</head>
<body>
    <h1>Liste des Exposants</h1>

    <form method="get" class="search-form">
        <div>
            <label for="NomExp">Nom :</label>
            <input type="text" id="NomExp" name="NomExp" value="<?= htmlspecialchars($_GET['NomExp'] ?? '') ?>">
        </div>
        <div>
            <label for="AdrVilleExp">Ville :</label>
            <input type="text" id="AdrVilleExp" name="AdrVilleExp" value="<?= htmlspecialchars($_GET['AdrVilleExp'] ?? '') ?>">
        </div>
        <div>
            <label for="AdrCPExp">Code Postal :</label>
            <input type="text" id="AdrCPExp" name="AdrCPExp" value="<?= htmlspecialchars($_GET['AdrCPExp'] ?? '') ?>">
        </div>
        <button type="submit" class="search-button">Rechercher</button>
        <a href="liste_exposant.php" class="reset-button">Réinitialiser</a>
    </form>
    <table class="exposant-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nom</th>
                <th>Rue</th>
                <th>Code Postal</th>
                <th>Ville</th>
                <th>Type</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($exposants) > 0): ?>
                <?php foreach ($exposants as $exposant): ?>
                    <tr>
                        <td><?= htmlspecialchars($exposant['NumeroExp']) ?></td>
                        <td><?= htmlspecialchars($exposant['NomExp']) ?></td>
                        <td><?= htmlspecialchars($exposant['AdrRueExp'] ?? '-') ?></td>
                        <td><?= htmlspecialchars($exposant['AdrCPExp'] ?? '-') ?></td>
                        <td><?= htmlspecialchars($exposant['AdrVilleExp'] ?? '-') ?></td>
                        <td><?= htmlspecialchars($exposant['CodeTypeExp'] ?? '-') ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="6">Aucun exposant trouvé avec les critères donnés.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
    <a href="sommaire.php" class="back-link">Retour au sommaire</a>
</body>
</html>