<?php
include 'auth.php';
checkRole(['admin', 'tech', 'gp']);

$location = $pdo->query("
    SELECT 
        l.NumeroLocation, 
        l.DateDebut, 
        l.DateFin, 
        l.PrixTotal, 
        e.NomExp, 
        ts.LibTypeStd
    FROM location l
    INNER JOIN exposant e ON l.NumeroExp = e.NumeroExp
    INNER JOIN stand s ON l.NumeroStand = s.NumeroStand
    INNER JOIN typestand ts ON s.CodeTypeStd = ts.CodeTypeStd
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Liste des Locations</title>
    <link rel="stylesheet" href="style/liste_locations.css">
</head>
<body>
    <h1>Liste des Locations</h1>
    <table class="location-table">
        <thead>
            <tr>
                <th>ID Location</th>
                <th>Date Début</th>
                <th>Date Fin</th>
                <th>Prix Total (€)</th>
                <th>Exposant</th>
                <th>Description Stand</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($location as $loc): ?>
                <tr>
                    <td><?= htmlspecialchars($loc['NumeroLocation']) ?></td>
                    <td><?= htmlspecialchars($loc['DateDebut']) ?></td>
                    <td><?= htmlspecialchars($loc['DateFin']) ?></td>
                    <td><?= htmlspecialchars($loc['PrixTotal']) ?> €</td>
                    <td><?= htmlspecialchars($loc['NomExp']) ?></td>
                    <td><?= htmlspecialchars($loc['LibTypeStd']) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <a href="sommaire.php" class="back-link">Retour au sommaire</a>
</body>
</html>

