<?php
include 'auth.php';
checkRole(['admin', 'tech', 'gp']);

try {
    $standQuery = $pdo->query("
        SELECT 
            s.NumeroStand,
            s.NumeroAllee,
            s.PlaceAllee,
            t.LibTypeStd AS DescriptionStand,
            e.NomExp AS NomExposant,
            l.Montant AS PrixStand
        FROM stand s
        LEFT JOIN typestand t ON s.CodeTypeStd = t.CodeTypeStd
        LEFT JOIN exposant e ON s.NumeroExp = e.NumeroExp
        LEFT JOIN louer l ON s.CodeTypeStd = l.CodeTypeStd
    ");
    $stands = $standQuery->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erreur de connexion : " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Liste des Stands</title>
    <link rel="stylesheet" href="style/liste_stand.css">
    <script>
        function filterTable() {
            const input = document.getElementById('searchInput').value.toLowerCase();
            const filterType = document.getElementById('filterType').value;
            const rows = document.querySelectorAll('.stand-row');

            rows.forEach(row => {
                const text = row.querySelector(`[data-filter="${filterType}"]`).textContent.toLowerCase();
                row.style.display = text.includes(input) ? '' : 'none';
            });
        }
    </script>
</head>
<body>
    <h1>Liste des Stands</h1>

    <div class="filter-container">
        <label for="filterType">Filtrer par :</label>
        <select id="filterType" onchange="filterTable()">
            <option value="NumeroStand">Numéro Stand</option>
            <option value="NomExposant">Exposant</option>
            <option value="DescriptionStand">Type de Stand</option>
            <option value="NumeroAllee">Allée</option>
        </select>
        <input type="text" id="searchInput" oninput="filterTable()" placeholder="Rechercher...">
    </div>

    <table class="stand-table">
        <thead>
            <tr>
                <th>Numéro Stand</th>
                <th>Allée</th>
                <th>Place</th>
                <th>Type de Stand</th>
                <th>Prix (€)</th>
                <th>Exposant</th>
                <th>Statut</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($stands as $stand): ?>
                <tr class="stand-row">
                    <td data-filter="NumeroStand"><?= htmlspecialchars($stand['NumeroStand']) ?></td>
                    <td data-filter="NumeroAllee"><?= htmlspecialchars($stand['NumeroAllee']) ?></td>
                    <td data-filter="PlaceAllee"><?= htmlspecialchars($stand['PlaceAllee']) ?></td>
                    <td data-filter="DescriptionStand"><?= htmlspecialchars($stand['DescriptionStand'] ?? 'N/A') ?></td>
                    <td><?= htmlspecialchars($stand['PrixStand'] ?? 'N/A') ?></td>
                    <td data-filter="NomExposant"><?= htmlspecialchars($stand['NomExposant'] ?? 'Non affecté') ?></td>
                    <td>
                        <?= $stand['NomExposant'] ? '<span class="status assigned">Affecté</span>' : '<span class="status unassigned">Non affecté</span>' ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <a href="sommaire.php" class="back-link">Retour au sommaire</a>
</body>
</html>
